
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    tomatoes = m.addVar(name="tomatoes")
    apples = m.addVar(name="apples")


    # Set objective function
    m.setObjective(9.8 * tomatoes + 9.86 * apples, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(15 * tomatoes + 23 * apples >= 24, "tastiness_min")
    m.addConstr(3 * tomatoes + 15 * apples >= 59, "carbohydrates_min")
    m.addConstr(22 * tomatoes + 2 * apples >= 47, "iron_min")
    m.addConstr(9 * tomatoes - 10 * apples >= 0, "tomatoes_apples_relation")
    m.addConstr(15 * tomatoes + 23 * apples <= 138, "tastiness_max")
    m.addConstr(3 * tomatoes + 15 * apples <= 225, "carbohydrates_max")
    m.addConstr(22 * tomatoes + 2 * apples <= 80, "iron_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('tomatoes:', tomatoes.x)
        print('apples:', apples.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

