
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
tomatoes = m.addVar(vtype=GRB.CONTINUOUS, name="tomatoes")
apples = m.addVar(vtype=GRB.CONTINUOUS, name="apples")

# Set the objective function
m.setObjective(9.8*tomatoes + 9.86*apples, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*tomatoes + 23*apples >= 24, "Combined_Tastiness_Min")
m.addConstr(3*tomatoes + 15*apples >= 59, "Combined_Carbohydrates_Min")
m.addConstr(22*tomatoes + 2*apples >= 47, "Combined_Iron_Min")
m.addConstr(9*tomatoes - 10*apples >= 0, "Tomatoes_Apples_Ratio")
m.addConstr(15*tomatoes + 23*apples <= 138, "Combined_Tastiness_Max")
m.addConstr(3*tomatoes + 15*apples <= 225, "Combined_Carbohydrates_Max")
m.addConstr(22*tomatoes + 2*apples <= 80, "Combined_Iron_Max")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Tomatoes: {tomatoes.x}")
    print(f"Apples: {apples.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found.")
