
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    tomatoes = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="tomatoes")
    apples = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="apples")

    # Define the objective function
    model.setObjective(9.8 * tomatoes + 9.86 * apples, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(15 * tomatoes + 23 * apples >= 24, name="tastiness_rating_min")
    model.addConstr(3 * tomatoes + 15 * apples >= 59, name="carbohydrates_min")
    model.addConstr(22 * tomatoes + 2 * apples >= 47, name="iron_min")
    model.addConstr(9 * tomatoes - 10 * apples >= 0, name="tomatoes_vs_apples")
    model.addConstr(15 * tomatoes + 23 * apples <= 138, name="tastiness_rating_max")
    model.addConstr(3 * tomatoes + 15 * apples <= 225, name="carbohydrates_max")
    model.addConstr(22 * tomatoes + 2 * apples <= 80, name="iron_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Tomatoes: {tomatoes.x}")
        print(f"Apples: {apples.x}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
