
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
kiwis = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="kiwis")
bacon = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bacon")
tomatoes = m.addVar(lb=0, vtype=GRB.INTEGER, name="tomatoes")
sandwiches = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="sandwiches")


# Set objective function
m.setObjective(1.26 * kiwis + 7.96 * bacon + 7.76 * tomatoes + 7.23 * sandwiches, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*kiwis + 2*bacon + 3*sandwiches >= 33, "c0")
m.addConstr(2*bacon + 9*tomatoes + 3*sandwiches >= 33, "c1")
m.addConstr(10*kiwis + 2*bacon + 3*sandwiches >= 26, "c2")
m.addConstr(2*bacon + 9*tomatoes + 3*sandwiches >= 26, "c3")
m.addConstr(10*kiwis + 7*tomatoes >= 18, "c4")
m.addConstr(10*kiwis + 7*sandwiches >= 41, "c5")
m.addConstr(10*kiwis + 8*bacon >= 47, "c6")
m.addConstr(7*tomatoes + 7*sandwiches >= 33, "c7")
m.addConstr(8*bacon + 7*tomatoes + 7*sandwiches >= 40, "c8")
m.addConstr(3*kiwis + 3*sandwiches >= 11, "c9")
m.addConstr(7*bacon + 3*sandwiches >= 12, "c10")
m.addConstr(3*kiwis + 8*tomatoes >= 11, "c11")
m.addConstr(3*kiwis + 7*bacon >= 11, "c12")
m.addConstr(9*tomatoes + 8*sandwiches >= 40, "c13")
m.addConstr(11*bacon + 8*sandwiches >= 24, "c14")
m.addConstr(8*kiwis + 8*sandwiches >= 41, "c15")
m.addConstr(8*kiwis + 9*tomatoes >= 50, "c16")
m.addConstr(8*kiwis + 11*bacon >= 43, "c17")
m.addConstr(8*kiwis + 9*tomatoes + 8*sandwiches >= 33, "c18")
m.addConstr(11*bacon + 9*tomatoes + 8*sandwiches >= 33, "c19")
m.addConstr(8*kiwis + 11*bacon + 8*sandwiches >= 33, "c20")
m.addConstr(8*kiwis + 9*tomatoes + 8*sandwiches >= 47, "c21")
m.addConstr(11*bacon + 9*tomatoes + 8*sandwiches >= 47, "c22")
m.addConstr(8*kiwis + 11*bacon + 8*sandwiches >= 47, "c23")
m.addConstr(8*kiwis + 9*tomatoes + 8*sandwiches >= 42, "c24")
m.addConstr(11*bacon + 9*tomatoes + 8*sandwiches >= 42, "c25")
m.addConstr(8*kiwis + 11*bacon + 8*sandwiches >= 42, "c26")
m.addConstr(9*tomatoes + 3*sandwiches <= 98, "c27")
m.addConstr(2*bacon + 9*tomatoes <= 104, "c28")
m.addConstr(10*kiwis + 2*bacon + 9*tomatoes + 3*sandwiches <= 104, "c29")
m.addConstr(10*kiwis + 7*sandwiches <= 60, "c30")
m.addConstr(10*kiwis + 8*bacon + 7*tomatoes + 7*sandwiches <= 60, "c31")
m.addConstr(3*kiwis + 7*bacon <= 66, "c32")
m.addConstr(8*tomatoes + 3*sandwiches <= 60, "c33")
m.addConstr(7*bacon + 3*sandwiches <= 33, "c34")
m.addConstr(3*kiwis + 3*sandwiches <= 78, "c35")
m.addConstr(3*kiwis + 8*tomatoes <= 74, "c36")
m.addConstr(7*bacon + 8*tomatoes + 3*sandwiches <= 88, "c37")
m.addConstr(3*kiwis + 7*bacon + 8*tomatoes <= 76, "c38")
m.addConstr(3*kiwis + 7*bacon + 3*sandwiches <= 75, "c39")
m.addConstr(3*kiwis + 7*bacon + 8*tomatoes + 3*sandwiches <= 75, "c40")
m.addConstr(11*bacon + 8*sandwiches <= 88, "c41")
m.addConstr(8*kiwis + 8*sandwiches <= 66, "c42")
m.addConstr(8*kiwis + 9*tomatoes <= 139, "c43")
m.addConstr(11*bacon + 9*tomatoes <= 209, "c44")
m.addConstr(8*kiwis + 11*bacon <= 107, "c45")
m.addConstr(8*kiwis + 9*tomatoes + 8*sandwiches <= 201, "c46")
m.addConstr(8*kiwis + 11*bacon + 9*tomatoes <= 113, "c47")
m.addConstr(8*kiwis + 11*bacon + 9*tomatoes + 8*sandwiches <= 113, "c48")


m.addConstr(10 * kiwis <= 160, "iron_kiwi_ub")
m.addConstr(8 * bacon <= 205, "fat_bacon_ub")
m.addConstr(8 * tomatoes <= 104, "protein_tomatoes_ub")
m.addConstr(8 * sandwiches <= 212, "sourness_sandwiches_ub")



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

