
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # kiwis
    x1 = model.addVar(name="x1", lb=0)  # strips of bacon
    x2 = model.addVar(name="x2", lb=0, integrality=1)  # tomatoes
    x3 = model.addVar(name="x3", lb=0)  # peanutbutter sandwiches

    # Objective function
    model.setObjective(1.26*x0 + 7.96*x1 + 7.76*x2 + 7.23*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(10*x0 + 2*x1 + 3*x3 >= 33)
    model.addConstr(2*x1 + 9*x2 + 3*x3 >= 33)
    model.addConstr(10*x0 + 2*x1 + 3*x3 >= 26)
    model.addConstr(2*x1 + 9*x2 + 3*x3 >= 26)
    model.addConstr(10*x0 + 7*x2 >= 18)
    model.addConstr(10*x0 + 7*x3 >= 41)
    model.addConstr(10*x0 + 8*x1 >= 47)
    model.addConstr(7*x2 + 7*x3 >= 33)
    model.addConstr(8*x1 + 7*x2 + 7*x3 >= 40)
    model.addConstr(3*x0 + 3*x3 >= 11)
    model.addConstr(7*x1 + 3*x3 >= 12)
    model.addConstr(3*x0 + 8*x2 >= 11)
    model.addConstr(3*x0 + 7*x1 >= 11)
    model.addConstr(9*x2 + 8*x3 >= 40)
    model.addConstr(11*x1 + 8*x3 >= 24)
    model.addConstr(8*x0 + 8*x3 >= 41)
    model.addConstr(8*x0 + 9*x2 >= 50)
    model.addConstr(11*x1 + 8*x0 >= 43)
    model.addConstr(8*x0 + 9*x2 + 8*x3 >= 33)
    model.addConstr(11*x1 + 9*x2 + 8*x3 >= 33)
    model.addConstr(8*x0 + 11*x1 + 8*x3 >= 33)
    model.addConstr(8*x0 + 9*x2 + 8*x3 >= 47)
    model.addConstr(11*x1 + 9*x2 + 8*x3 >= 47)
    model.addConstr(8*x0 + 11*x1 + 8*x3 >= 47)
    model.addConstr(8*x0 + 9*x2 + 8*x3 >= 42)
    model.addConstr(11*x1 + 9*x2 + 8*x3 >= 42)
    model.addConstr(8*x0 + 11*x1 + 8*x3 >= 42)
    model.addConstr(9*x2 + 3*x3 <= 98)
    model.addConstr(2*x1 + 9*x2 <= 104)
    model.addConstr(10*x0 + 2*x1 + 9*x2 + 3*x3 <= 104)
    model.addConstr(10*x0 + 7*x3 <= 60)
    model.addConstr(10*x0 + 8*x1 + 7*x2 + 7*x3 <= 60)
    model.addConstr(3*x0 + 7*x1 <= 66)
    model.addConstr(8*x2 + 3*x3 <= 60)
    model.addConstr(7*x1 + 3*x3 <= 33)
    model.addConstr(3*x0 + 3*x3 <= 78)
    model.addConstr(3*x0 + 8*x2 <= 74)
    model.addConstr(7*x1 + 8*x2 + 3*x3 <= 88)
    model.addConstr(3*x0 + 7*x1 + 8*x2 <= 76)
    model.addConstr(3*x0 + 7*x1 + 8*x2 + 3*x3 <= 75)
    model.addConstr(3*x0 + 7*x1 + 8*x2 + 3*x3 <= 75)
    model.addConstr(11*x1 + 8*x3 <= 88)
    model.addConstr(8*x0 + 8*x3 <= 66)
    model.addConstr(8*x0 + 9*x2 <= 139)
    model.addConstr(11*x1 + 9*x2 <= 209)
    model.addConstr(8*x0 + 11*x1 <= 107)
    model.addConstr(8*x0 + 9*x2 + 8*x3 <= 201)
    model.addConstr(8*x0 + 11*x1 + 9*x2 <= 113)
    model.addConstr(8*x0 + 11*x1 + 9*x2 + 8*x3 <= 113)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Kiwis: ", x0.varValue)
        print("Strips of bacon: ", x1.varValue)
        print("Tomatoes: ", x2.varValue)
        print("Peanutbutter sandwiches: ", x3.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
