
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("carbohydrate_optimization")

    # Create variables
    apple_pies = m.addVar(vtype=GRB.INTEGER, name="apple_pies")
    potatoes = m.addVar(vtype=GRB.CONTINUOUS, name="potatoes")

    # Set objective function
    m.setObjective(5.57 * apple_pies + 6.93 * potatoes, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(9.23 * apple_pies + 12.35 * potatoes >= 18, "carbohydrate_minimum")
    m.addConstr(8 * apple_pies - 4 * potatoes >= 0, "apple_pies_potatoes_ratio")
    m.addConstr(9.23 * apple_pies + 12.35 * potatoes <= 33, "carbohydrate_maximum")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print(f"Optimal objective value: {m.objVal}")
        print(f"Apple Pies: {apple_pies.x}")
        print(f"Potatoes: {potatoes.x}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
