
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="apple_pies")  # Integer variable for apple pies
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="potatoes")  # Continuous variable for potatoes

# Set the objective function
m.setObjective(5.57*x1 + 6.93*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(9.23*x1 + 12.35*x2 >= 18, name="carb_min")
m.addConstr(8*x1 - 4*x2 >= 0, name="combination_constraint")
m.addConstr(9.23*x1 + 12.35*x2 <= 33, name="carb_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Apple Pies: {x1.x}")
    print(f"Potatoes: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
