
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    apple_pies = model.addVar(name="apple_pies", vtype=gurobi.GRB.INTEGER)
    potatoes = model.addVar(name="potatoes")

    # Objective function
    model.setObjective(5.57 * apple_pies + 6.93 * potatoes, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(9.23 * apple_pies + 12.35 * potatoes >= 18)
    model.addConstr(8 * apple_pies - 4 * potatoes >= 0)
    model.addConstr(9.23 * apple_pies + 12.35 * potatoes <= 53)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Apple pies: {apple_pies.varValue}")
        print(f"Potatoes: {potatoes.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
