
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_b9 = m.addVar(lb=0, name="vitamin_b9")
vitamin_b12 = m.addVar(lb=0, name="vitamin_b12")
zinc = m.addVar(lb=0, name="zinc")
vitamin_c = m.addVar(lb=0, name="vitamin_c")

# Set objective function
m.setObjective(4.34*vitamin_b9**2 + 7.52*vitamin_b9*vitamin_b12 + 7.76*vitamin_b9*zinc + 2.03*vitamin_b9*vitamin_c + 8.76*vitamin_b12**2 + 4.31*vitamin_b12*vitamin_c + 3.41*zinc**2 + 5.53*zinc*vitamin_c + 8.67*vitamin_b12 + 7.33*zinc + 1.46*vitamin_c, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3.64*vitamin_b9 + 4.21*vitamin_b12 + 2.45*zinc + 4.62*vitamin_c <= 241, "muscle_growth_index")
m.addConstr(4.18*vitamin_b9 + 6.2*vitamin_b12 + 8.81*zinc + 6.88*vitamin_c <= 117, "energy_stability_index")
m.addConstr(4.21*vitamin_b12 + 2.45*zinc >= 59, "c1")
m.addConstr(4.21*vitamin_b12 + 4.62*vitamin_c >= 28, "c2")
m.addConstr(3.64*vitamin_b9 + 2.45*zinc >= 21, "c3")
m.addConstr(3.64*vitamin_b9 + 4.62*vitamin_c >= 25, "c4")
m.addConstr(3.64*vitamin_b9**2 + 4.21*vitamin_b12**2 >= 39, "c5")
m.addConstr(4.21*vitamin_b12 + 2.45*zinc + 4.62*vitamin_c >= 59, "c6")
m.addConstr(3.64*vitamin_b9 + 4.21*vitamin_b12 + 2.45*zinc + 4.62*vitamin_c >= 59, "c7")
m.addConstr(4.18*vitamin_b9 + 6.88*vitamin_c >= 29, "c8")
m.addConstr(4.18*vitamin_b9 + 6.2*vitamin_b12 >= 20, "c9")
m.addConstr(4.18*vitamin_b9 + 8.81*zinc >= 10, "c10")
m.addConstr(6.2*vitamin_b12**2 + 6.88*vitamin_c**2 >= 18, "c11")
m.addConstr(4.18*vitamin_b9 + 6.2*vitamin_b12 + 8.81*zinc + 6.88*vitamin_c >= 18, "c12")
m.addConstr(3*vitamin_b9**2 - 2*vitamin_c**2 >= 0, "c13")
m.addConstr(3.64*vitamin_b9 + 4.62*vitamin_c <= 128, "c14")
m.addConstr(4.21*vitamin_b12 + 2.45*zinc + 4.62*vitamin_c <= 128, "c15")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

