
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x1 = m.addVar(name="x1", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x2 = m.addVar(name="x2", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x3 = m.addVar(name="x3", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Objective function
m.setObjective(4.34*x0**2 + 7.52*x0*x1 + 7.76*x0*x2 + 2.03*x0*x3 + 
               8.76*x1**2 + 4.31*x1*x3 + 3.41*x2**2 + 5.53*x2*x3 + 
               8.67*x1 + 7.33*x2 + 1.46*x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(3.64*x0 == 3.64, name="c1")
m.addConstr(4.18*x0 == 4.18, name="c2")
m.addConstr(4.21*x1 == 4.21, name="c3")
m.addConstr(6.2*x1 == 6.2, name="c4")
m.addConstr(2.45*x2 == 2.45, name="c5")
m.addConstr(8.81*x2 == 8.81, name="c6")
m.addConstr(4.62*x3 == 4.62, name="c7")
m.addConstr(6.88*x3 == 6.88, name="c8")
m.addConstr(4.21*x1 + 2.45*x2 >= 59, name="c9")
m.addConstr(4.21*x1 + 4.62*x3 >= 28, name="c10")
m.addConstr(3.64*x0 + 2.45*x2 >= 21, name="c11")
m.addConstr(3.64*x0 + 4.62*x3 >= 25, name="c12")
m.addConstr((3.64*x0)**2 + (4.21*x1)**2 >= 39, name="c13")
m.addConstr(4.21*x1 + 2.45*x2 + 4.62*x3 >= 59, name="c14")
m.addConstr(3.64*x0 + 4.21*x1 + 2.45*x2 + 4.62*x3 >= 59, name="c15")
m.addConstr(4.18*x0 + 6.88*x3 >= 29, name="c16")
m.addConstr(4.18*x0 + 6.2*x1 >= 20, name="c17")
m.addConstr(4.18*x0 + 8.81*x2 >= 10, name="c18")
m.addConstr((6.2*x1)**2 + (6.88*x3)**2 >= 18, name="c19")
m.addConstr(4.18*x0 + 6.2*x1 + 8.81*x2 + 6.88*x3 >= 18, name="c20")
m.addConstr(3*(3.64*x0)**2 - 2*(4.62*x3)**2 >= 0, name="c21")
m.addConstr(3.64*x0 + 4.62*x3 <= 128, name="c22")
m.addConstr(4.21*x1 + 2.45*x2 + 4.62*x3 <= 128, name="c23")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.Status.OPTIMAL:
    print("Objective: ", m.objval)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
