
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(6, lb=0, vtype=gp.GRB.CONTINUOUS, name=["apple pies", "fruit salads", "granola bars", "apples", "chicken drumsticks", "oreos"])


# Set objective function
m.setObjective(8.17*x[0]**2 + 3.12*x[0]*x[1] + 7.03*x[0]*x[3] + 6.42*x[0]*x[4] + 9.3*x[0]*x[5] + 5.5*x[1]*x[3] + 9.41*x[1]*x[5] + 2.68*x[1] + 5.89*x[2] + 9.05*x[3], gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(17*x[0] + 17*x[1] + 12*x[2] + 13*x[3] + 14*x[4] + 14*x[5] <= 262, "r0")
m.addConstr(10*x[0] + 2*x[1] + 12*x[2] + 10*x[3] + 13*x[4] + 8*x[5] <= 293, "r1")
m.addConstr(15*x[0] + 15*x[1] + 7*x[2] + 12*x[3] + 14*x[4] + 3*x[5] <= 213, "r2")
m.addConstr(5*x[0] + 8*x[1] + 8*x[2] + 11*x[3] + 8*x[4] + 15*x[5] <= 213, "r3")
m.addConstr(6*x[0] + 17*x[1] + 6*x[2] + 1*x[3] + 9*x[4] + 11*x[5] <= 325, "r4")
# ... (add all other constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("Optimization terminated with status:", m.status)

