
from gurobipy import *

# Create a new model
m = Model("Nutrition_Optimization")

# Define variables
x1 = m.addVar(name='apple_pies')
x2 = m.addVar(name='fruit_salads')
x3 = m.addVar(name='granola_bars')
x4 = m.addVar(name='apples')
x5 = m.addVar(name='chicken_drumsticks')
x6 = m.addVar(name='oreos')

# Constraints
m.addConstr(49*x1 + 30*x2 + 20*x3 + 10*x4 + 15*x5 + 25*x6 >= 130, name='fiber_constraint')
m.addConstr(-3*x2**2 + 9*x5**2 >= 0, name='iron_constraint')
m.addConstr(x1**2 + x2**2 + x5**2 <= 130, name='sourness_index')
m.addConstr(x4**2 + x6**2 <= 112, name='iron_limit')

# Add other constraints similarly

# Objective: Since we're just looking for a feasible solution, no objective is set
m.optimize()
