
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_model")

# Create variables
ringo = m.addVar(vtype=gp.GRB.INTEGER, name="ringo")
hank = m.addVar(vtype=gp.GRB.CONTINUOUS, name="hank")
john = m.addVar(vtype=gp.GRB.INTEGER, name="john")
bill = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bill")


# Set objective function
m.setObjective(8*ringo**2 + ringo*john + 5*ringo*bill + 4*hank**2 + john**2 + 4*ringo + 3*hank + 5*john + 5*bill, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*ringo**2 + 5*hank**2 >= 35)
m.addConstr(5*hank + 2*bill >= 19)
m.addConstr(5*ringo**2 + john**2 >= 27)
m.addConstr(5*hank + john >= 23)
m.addConstr(john + 2*bill >= 35)
m.addConstr(5*ringo + john + 2*bill >= 21)
m.addConstr(5*ringo**2 + 5*hank**2 + john**2 >= 21)
m.addConstr(5*ringo + 5*hank + 2*bill >= 21)
m.addConstr(5*hank + john + 2*bill >= 21)
m.addConstr(5*ringo + john + 2*bill >= 30)
m.addConstr(5*ringo**2 + 5*hank**2 + john**2 >= 30)
m.addConstr(5*ringo + 5*hank + 2*bill >= 30)
m.addConstr(5*hank**2 + john**2 + 2*bill**2 >= 30)
m.addConstr(5*ringo + john + 2*bill >= 27)
m.addConstr(5*ringo**2 + 5*hank**2 + john**2 >= 27)
m.addConstr(5*ringo + 5*hank + 2*bill >= 27)
m.addConstr(5*hank + john + 2*bill >= 27)
m.addConstr(5*ringo**2 + john**2 + 2*bill**2 >= 29)
m.addConstr(5*ringo + 5*hank + john >= 29)
m.addConstr(5*ringo + 5*hank + 2*bill >= 29)
m.addConstr(5*hank**2 + john**2 + 2*bill**2 >= 29)
m.addConstr(5*hank + 11*bill >= 33)
m.addConstr(5*hank + 7*john >= 33)
m.addConstr(7*ringo + 11*bill >= 25)
m.addConstr(5*ringo + 5*hank <= 45)
m.addConstr(5*hank + john <= 94)
m.addConstr(5*hank + 2*bill <= 47)
m.addConstr(5*ringo**2 + john**2 <= 83)
m.addConstr(john + 2*bill <= 100)
m.addConstr(5*ringo**2 + 5*hank**2 + 2*bill**2 <= 66)
m.addConstr(5*ringo + 5*hank + john + 2*bill <= 66)
m.addConstr(25*hank**2 + 121*bill**2 <= 92)
m.addConstr(7*ringo + 11*bill <= 113)
m.addConstr(7*ringo + 7*john + 11*bill <= 93)
m.addConstr(7*ringo + 5*hank + 7*john + 11*bill <= 93)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

