
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name='x0', vtype=gurobi.GRB.INTEGER)  # hours worked by Ringo
    x1 = model.addVar(name='x1')  # hours worked by Hank
    x2 = model.addVar(name='x2', vtype=gurobi.GRB.INTEGER)  # hours worked by John
    x3 = model.addVar(name='x3')  # hours worked by Bill

    # Objective function
    model.setObjective(8 * x0**2 + x0 * x2 + 5 * x0 * x3 + 4 * x1**2 + x2**2 + 4 * x0 + 3 * x1 + 5 * x2 + 5 * x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5 * x0 <= 143)
    model.addConstr(7 * x0 <= 140)
    model.addConstr(5 * x1 <= 143)
    model.addConstr(5 * x1 <= 140)
    model.addConstr(x2 <= 143)
    model.addConstr(7 * x2 <= 140)
    model.addConstr(2 * x3 <= 143)
    model.addConstr(11 * x3 <= 140)
    model.addConstr(5 * x0**2 + 5 * x1**2 >= 35)
    model.addConstr(5 * x1 + 2 * x3 >= 19)
    model.addConstr(5 * x0**2 + x2**2 >= 27)
    model.addConstr(5 * x1 + x2 >= 23)
    model.addConstr(x2 + 2 * x3 >= 35)
    model.addConstr(5 * x0 + x2 + 2 * x3 >= 21)
    model.addConstr(5 * x0**2 + 5 * x1**2 + x2**2 >= 21)
    model.addConstr(5 * x0 + 5 * x1 + 2 * x3 >= 21)
    model.addConstr(5 * x1 + x2 + 2 * x3 >= 21)
    model.addConstr(5 * x0 + x2 + 2 * x3 >= 30)
    model.addConstr(5 * x0**2 + 5 * x1**2 + x2**2 >= 30)
    model.addConstr(5 * x0 + 5 * x1 + 2 * x3 >= 30)
    model.addConstr(5 * x1**2 + x2**2 + 4 * x3**2 >= 30)
    model.addConstr(5 * x0 + x2 + 2 * x3 >= 27)
    model.addConstr(5 * x0**2 + 5 * x1**2 + x2**2 >= 27)
    model.addConstr(5 * x0 + 5 * x1 + 2 * x3 >= 27)
    model.addConstr(5 * x1 + x2 + 2 * x3 >= 27)
    model.addConstr(5 * x0**2 + x2**2 + 4 * x3**2 >= 29)
    model.addConstr(5 * x0 + 5 * x1 + x2 >= 29)
    model.addConstr(5 * x0 + 5 * x1 + 2 * x3 >= 29)
    model.addConstr(5 * x1**2 + x2**2 + 4 * x3**2 >= 29)
    model.addConstr(5 * x1 + 11 * x3 >= 33)
    model.addConstr(5 * x1 + 7 * x2 >= 33)
    model.addConstr(7 * x0 + 11 * x3 >= 25)
    model.addConstr(5 * x0 + 5 * x1 <= 45)
    model.addConstr(5 * x1 + x2 <= 94)
    model.addConstr(5 * x1 + 2 * x3 <= 47)
    model.addConstr(5 * x0**2 + x2**2 <= 83)
    model.addConstr(x2 + 2 * x3 <= 100)
    model.addConstr(5 * x0**2 + 5 * x1**2 + 4 * x3**2 <= 66)
    model.addConstr(5 * x0 + 5 * x1 + x2 + 2 * x3 <= 66)
    model.addConstr(25 * x1**2 + 121 * x3**2 <= 92)
    model.addConstr(7 * x0 + 11 * x3 <= 113)
    model.addConstr(7 * x0 + 7 * x2 + 11 * x3 <= 93)
    model.addConstr(7 * x0 + 5 * x1 + 7 * x2 + 11 * x3 <= 93)

    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
