
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cornichons")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strawberries")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cantaloupes")
    x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls_of_pasta")


    # Set objective function
    m.setObjective(5.5 * x0 + 6.03 * x1 + 7.82 * x2 + 6.25 * x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(x1 + x2 >= 20)
    m.addConstr(x2 + x3 >= 14)
    m.addConstr(x0 + x1 + x2 + x3 >= 14)
    m.addConstr(14 * x0 + 4 * x1 >= 23)
    m.addConstr(10 * x2 + 1 * x3 >= 55)
    m.addConstr(14 * x0 + 10 * x2 >= 55)
    m.addConstr(14 * x0 + 4 * x1 + 1 * x3 >= 37)
    m.addConstr(14 * x0 + 4 * x1 + 10 * x2 + 1 * x3 >= 37)
    m.addConstr(-x1 + x2 >= 0)
    m.addConstr(4 * x0 - 6 * x3 >= 0)
    m.addConstr(6 * x0 + 1 * x1 <= 61)
    m.addConstr(1 * x1 + 11 * x2 <= 36)
    m.addConstr(6 * x0 + 11 * x2 <= 70)
    m.addConstr(11 * x2 + 14 * x3 <= 91)
    m.addConstr(14 * x0 + 10 * x2 <= 72)
    m.addConstr(6 * x0 + 1 * x1 + 11 * x2 + 14 * x3 <= 92)
    m.addConstr(14 * x0 + 4 * x1 + 10 * x2 + 1 * x3 <= 223)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
