
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="cornichons", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x1 = model.addVar(name="strawberries", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="cantaloupes", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x3 = model.addVar(name="bowls of pasta", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(5.5*x0 + 6.03*x1 + 7.82*x2 + 6.25*x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(6*x0 + x1 + 11*x2 + 14*x3 <= 92)
    model.addConstr(14*x0 + 4*x1 + 10*x2 + x3 <= 223)
    model.addConstr(x1 + 11*x2 >= 20)
    model.addConstr(11*x2 + 14*x3 >= 14)
    model.addConstr(6*x0 + x1 + 11*x2 + 14*x3 >= 14)
    model.addConstr(14*x0 + 4*x1 >= 23)
    model.addConstr(10*x2 + x3 >= 55)
    model.addConstr(14*x0 + 10*x2 >= 55)
    model.addConstr(14*x0 + 4*x1 + x3 >= 37)
    model.addConstr(14*x0 + 4*x1 + 10*x2 + x3 >= 37)
    model.addConstr(-x1 + x2 >= 0)
    model.addConstr(4*x0 - 6*x3 >= 0)
    model.addConstr(6*x0 + x1 <= 61)
    model.addConstr(x1 + 11*x2 <= 36)
    model.addConstr(6*x0 + 11*x2 <= 70)
    model.addConstr(11*x2 + 14*x3 <= 91)
    model.addConstr(14*x0 + 10*x2 <= 72)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print("Objective: ", model.objval)
        print("cornichons: ", x0.x)
        print("strawberries: ", x1.x)
        print("cantaloupes: ", x2.x)
        print("bowls of pasta: ", x3.x)
    else:
        print("No optimal solution found.")

optimize_problem()
