
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="airborne_infantry_companies")
    x1 = m.addVar(vtype=GRB.INTEGER, name="engineer_platoons")
    x2 = m.addVar(vtype=GRB.INTEGER, name="air_defense_batteries")


    # Set objective function
    m.setObjective(7*x0**2 + 5*x0*x1 + 5*x0*x2 + 3*x1**2 + x2**2 + 9*x0 + x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(12*x0 + 10*x2 >= 33, "c0")
    m.addConstr(13*x1 + 10*x2 >= 36, "c1")
    m.addConstr(12*x0 + 13*x1 + 10*x2 >= 36, "c2")
    m.addConstr(4*x0 + 4*x2 >= 57, "c3")
    m.addConstr(4*x0 + 11*x1 + 4*x2 >= 57, "c4")
    m.addConstr(2*x0 - 5*x2 >= 0, "c5")
    m.addConstr(144*x0**2 + 169*x1**2 + 100*x2**2 <= 66, "c6") #Simplified squares
    m.addConstr(4*x0 + 4*x2 <= 146, "c7")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
        print('x2: %g' % x2.x)
    elif m.status == GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)



except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
