
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="airborne_infantry_companies")
x1 = m.addVar(vtype=GRB.INTEGER, name="engineer_platoons")
x2 = m.addVar(vtype=GRB.INTEGER, name="air_defense_batteries")

# Define the objective function
m.setObjective(7*x0**2 + 5*x0*x1 + 5*x0*x2 + 3*x1**2 + x2**2 + 9*x0 + x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(12*x0 + 10*x2 >= 33)
m.addConstr(13*x1 + 10*x2 >= 36)
m.addConstr(12*x0 + 13*x1 + 10*x2 >= 36)
m.addConstr(4*x0 + 4*x2 >= 57)
m.addConstr(4*x0 + 11*x1 + 4*x2 >= 57)
m.addConstr(2*x0 - 5*x2 >= 0)
m.addConstr((12*x0)**2 + (13*x1)**2 + (10*x2)**2 <= 66)
m.addConstr(4*x0 + 4*x2 <= 146)

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Airborne Infantry Companies: {x0.x}")
    print(f"Engineer Platoons: {x1.x}")
    print(f"Air Defense Batteries: {x2.x}")
else:
    print("No optimal solution found")
