
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="airborne_infantry_companies", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="engineer_platoons", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="air_defense_batteries", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(7*x0**2 + 5*x0*x1 + 5*x0*x2 + 3*x1**2 + x2**2 + 9*x0 + x1, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(12*x0 <= 120)
m.addConstr(4*x0 <= 197)
m.addConstr(13*x1 <= 120)
m.addConstr(11*x1 <= 197)
m.addConstr(10*x2 <= 120)
m.addConstr(4*x2 <= 197)
m.addConstr(12*x0 + 10*x2 >= 33)
m.addConstr(13*x1 + 10*x2 >= 36)
m.addConstr(12*x0 + 13*x1 + 10*x2 >= 36)
m.addConstr(4*x0 + 4*x2 >= 57)
m.addConstr(4*x0 + 11*x1 + 4*x2 >= 57)
m.addConstr(2*x0 - 5*x2 >= 0)
m.addConstr(144*x0**2 + 169*x1**2 + 100*x2**2 <= 66)
m.addConstr(4*x0 + 4*x2 <= 146)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Airborne Infantry Companies: ", x0.varValue)
    print("Engineer Platoons: ", x1.varValue)
    print("Air Defense Batteries: ", x2.varValue)
else:
    print("The model is infeasible")
