
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="packs_of_napkins")
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="packs_of_paper_plates")


    # Set objective function
    model.setObjective(5*x0 + 7*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(5.09*x0 + 4.07*x1 >= 74, "cost_lower_bound")
    model.addConstr(21.18*x0 + 16.72*x1 >= 87, "sustainability_lower_bound")
    model.addConstr(7.98*x0 + 26.08*x1 >= 41, "value_lower_bound")
    model.addConstr(9.28*x0 + 20.6*x1 >= 49, "weight_lower_bound")
    model.addConstr(24.55*x0 + 10.12*x1 >= 34, "portability_lower_bound")
    model.addConstr(10*x0 - 5*x1 >= 0, "napkins_plates_ratio")
    model.addConstr(5.09*x0 + 4.07*x1 <= 210, "cost_upper_bound")
    model.addConstr(21.18*x0 + 16.72*x1 <= 98, "sustainability_upper_bound")
    model.addConstr(7.98*x0 + 26.08*x1 <= 127, "value_upper_bound")
    model.addConstr(9.28*x0 + 20.6*x1 <= 199, "weight_upper_bound")
    model.addConstr(24.55*x0 + 10.12*x1 <= 111, "portability_upper_bound")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('packs_of_napkins:', x0.x)
        print('packs_of_paper_plates:', x1.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
