
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="packs_of_napkins", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="packs_of_paper_plates", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(5 * x1 + 7 * x2, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(5.09 * x1 + 4.07 * x2 >= 74, name="cost_constraint")
m.addConstr(21.18 * x1 + 16.72 * x2 >= 87, name="sustainability_score_constraint")
m.addConstr(7.98 * x1 + 26.08 * x2 >= 41, name="value_constraint")
m.addConstr(9.28 * x1 + 20.6 * x2 >= 49, name="weight_constraint")
m.addConstr(24.55 * x1 + 10.12 * x2 >= 34, name="portability_rating_constraint")
m.addConstr(10 * x1 - 5 * x2 >= 0, name="ratio_constraint")
m.addConstr(5.09 * x1 + 4.07 * x2 <= 210, name="budget_constraint")
m.addConstr(21.18 * x1 + 16.72 * x2 <= 98, name="max_sustainability_score_constraint")
m.addConstr(7.98 * x1 + 26.08 * x2 <= 127, name="max_value_constraint")
m.addConstr(9.28 * x1 + 20.6 * x2 <= 199, name="max_weight_constraint")
m.addConstr(24.55 * x1 + 10.12 * x2 <= 111, name="max_portability_rating_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("packs of napkins: ", x1.varValue)
    print("packs of paper plates: ", x2.varValue)
else:
    print("The model is infeasible")
