
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
b1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="b1")
fiber = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fiber")
d = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="d")
b3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="b3")
b9 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="b9")
k = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="k")
e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="e")


# Set objective
m.setObjective(4.16 * b1 + 8.43 * fiber + 5.54 * d + 7.63 * b3 + 8.31 * b9 + 7.2 * k + 1.45 * e, gp.GRB.MAXIMIZE)

# Add constraints - Immune and Digestive Support Indices
m.addConstr(7 * b1 + 20 * fiber + 6 * d + 1 * b3 + 10 * b9 + 26 * k + 25 * e <= 665, "r0")
m.addConstr(6 * b1 + 19 * fiber + 1 * d + 11 * b3 + 3 * b9 + 23 * k + 12 * e <= 395, "r1")


# Add simplified combined index constraints (after removing redundant constraints)
m.addConstr(6 * d + 1 * b3 + 25 * e >= 54)
m.addConstr(10 * b9 + 26 * k + 25 * e >= 54)
m.addConstr(1 * b3 + 26 * k + 25 * e >= 54)
m.addConstr(20 * fiber + 6 * d + 1 * b3 >= 54)
m.addConstr(1 * b3 + 10 * b9 + 26 * k >= 54)
m.addConstr(7 * b1 + 20 * fiber + 10 * b9 >= 54)
m.addConstr(19 * fiber + 1 * d <= 84)
m.addConstr(11 * b3 + 3 * b9 <= 86)
m.addConstr(1 * d + 3 * b9 <= 201)
m.addConstr(6 * b1 + 19 * fiber <= 375)
m.addConstr(3 * b9 + 23 * k <= 458)
m.addConstr(1 * d + 11 * b3 <= 444)



# Optimize model
m.optimize()

# Print solution or infeasibility message
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization was stopped with status %d' % m.status)
    # Compute and print IIS
    m.computeIIS()
    m.write("model.ilp")
    print('\nThe following constraint(s) cannot be satisfied:')
    for c in m.getConstrs():
        if c.IISConstr:
            print('%s' % c.constrName)
else:
    print('Optimization was stopped with status %d' % m.status)

