
import gurobipy as gp

# Create a new model
model = gp.Model("optimize_work_hours")

# Create variables
ringo_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo_hours")
mary_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary_hours")


# Set objective function
model.setObjective(2 * ringo_hours + 8 * mary_hours, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(15 * ringo_hours + 4 * mary_hours >= 23, "combined_likelihood_min")
model.addConstr(-8 * ringo_hours + 3 * mary_hours >= 0, "work_ratio")
model.addConstr(15 * ringo_hours + 4 * mary_hours <= 84, "combined_likelihood_max")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Ringo's hours: {ringo_hours.x}")
    print(f"  Mary's hours: {mary_hours.x}")
    print(f"  Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

