
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, name="hours_worked_by_Ringo")
x2 = m.addVar(lb=0, name="hours_worked_by_Mary")

# Set the objective function
m.setObjective(2*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x1 + 4*x2 >= 23, name="Combined_Quit_Index_Min")
m.addConstr(-8*x1 + 3*x2 >= 0, name="Ringo_Mary_Balance")
m.addConstr(15*x1 + 4*x2 <= 84, name="Combined_Quit_Index_Max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Ringo: {x1.x}")
    print(f"Hours worked by Mary: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
