
import gurobi as gp

# Create a new model
m = gp.Model("Optimization Problem")

# Define the variables
x1 = m.addVar(name="hours_worked_by_Ringo", lb=0)  
x2 = m.addVar(name="hours_worked_by_Mary", lb=0)   

# Define the objective function
m.setObjective(2*x1 + 8*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x1 + 4*x2 >= 23, name="likelihood_to_quit_index_min")
m.addConstr(-8*x1 + 3*x2 >= 0, name="hours_worked_constraint")
m.addConstr(15*x1 + 4*x2 <= 84, name="likelihood_to_quit_index_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Ringo: {x1.varValue}")
    print(f"Hours worked by Mary: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
