
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    sashimi = m.addVar(vtype=GRB.INTEGER, name="sashimi")
    fruit_salads = m.addVar(vtype=GRB.CONTINUOUS, name="fruit_salads")


    # Set objective function
    m.setObjective(7 * sashimi + 7 * fruit_salads, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(21 * sashimi + 3 * fruit_salads >= 36, "carbohydrates_min")
    m.addConstr(10 * sashimi + 11 * fruit_salads >= 57, "umami_min")
    m.addConstr(8 * sashimi - 5 * fruit_salads >= 0, "sashimi_fruit_ratio")
    m.addConstr(21 * sashimi + 3 * fruit_salads <= 77, "carbohydrates_max")
    m.addConstr(10 * sashimi + 11 * fruit_salads <= 71, "umami_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print(f"Optimal objective value: {m.objVal}")
        print(f"Sashimi: {sashimi.x}")
        print(f"Fruit Salads: {fruit_salads.x}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
