
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="sashimi")  # Sashimi must be an integer
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="fruit_salads")  # Fruit salads can be a fraction

# Objective function: Minimize 7*x1 + 7*x2
m.setObjective(7*x1 + 7*x2, GRB.MINIMIZE)

# Constraints
m.addConstr(21*x1 + 3*x2 >= 36, name="carb_min")  # At least 36 grams of carbohydrates
m.addConstr(10*x1 + 11*x2 >= 57, name="umami_min")  # Umami index at least 57
m.addConstr(8*x1 - 5*x2 >= 0, name="quantity_constraint")  # Constraint on quantities
m.addConstr(21*x1 + 3*x2 <= 77, name="carb_max")  # No more than 77 grams of carbohydrates
m.addConstr(10*x1 + 11*x2 <= 71, name="umami_max")  # Umami index no more than 71

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Sashimi: {x1.x}")
    print(f"Fruit Salads: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
