
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
sashimi = m.addVar(name="sashimi", vtype=gp.GRB.INTEGER)  # integer variable
fruit_salads = m.addVar(name="fruit_salads")  # continuous variable

# Objective function: minimize 7 * sashimi + 7 * fruit_salads
m.setObjective(7 * sashimi + 7 * fruit_salads, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(21 * sashimi + 3 * fruit_salads >= 36, name="carbohydrates_constraint")
m.addConstr(10 * sashimi + 11 * fruit_salads >= 57, name="umami_index_constraint")
m.addConstr(8 * sashimi - 5 * fruit_salads >= 0, name="sashimi_fruit_mix_constraint")
m.addConstr(21 * sashimi + 3 * fruit_salads <= 82, name="carbohydrates_upper_bound_constraint")
m.addConstr(10 * sashimi + 11 * fruit_salads <= 71, name="umami_index_upper_bound_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Sashimi: {sashimi.varValue}")
    print(f"Fruit Salads: {fruit_salads.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
