
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="smoke_detectors")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="packs_of_paper")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="black_pens")


    # Set objective function
    m.setObjective(6*x0 + 2*x1 + 5*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(13.06*x1 + 12.85*x2 >= 45, "c0")
    m.addConstr(8.84*x0 + 12.85*x2 >= 31, "c1")
    m.addConstr(8.84*x0 + 13.06*x1 + 12.85*x2 >= 50, "c2")
    m.addConstr(2.88*x0 + 7.18*x2 >= 61, "c3")
    m.addConstr(14.55*x1 + 7.18*x2 >= 27, "c4")
    m.addConstr(2.88*x0 + 14.55*x1 + 7.18*x2 >= 27, "c5")
    m.addConstr(6.67*x1 + 7.17*x2 >= 15, "c6")
    m.addConstr(8.91*x0 + 6.67*x1 + 7.17*x2 >= 15, "c7")
    m.addConstr(-x1 + 2*x2 >= 0, "c8")
    m.addConstr(3*x0 - 2*x2 >= 0, "c9")
    m.addConstr(14.55*x1 + 7.18*x2 <= 73, "c10")
    m.addConstr(2.88*x0 + 14.55*x1 <= 161, "c11")
    m.addConstr(8.91*x0 + 6.67*x1 <= 34, "c12")
    m.addConstr(8.91*x0 + 6.67*x1 + 7.17*x2 <= 77, "c13")



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
