
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="smoke detectors", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="packs of paper", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="black pens", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(6 * x0 + 2 * x1 + 5 * x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8.84 * x0 <= 167)
m.addConstr(2.88 * x0 <= 185)
m.addConstr(8.91 * x0 <= 85)
m.addConstr(13.06 * x1 <= 167)
m.addConstr(14.55 * x1 <= 185)
m.addConstr(6.67 * x1 <= 85)
m.addConstr(12.85 * x2 <= 167)
m.addConstr(7.18 * x2 <= 185)
m.addConstr(7.17 * x2 <= 85)
m.addConstr(13.06 * x1 + 12.85 * x2 >= 45)
m.addConstr(8.84 * x0 + 12.85 * x2 >= 31)
m.addConstr(8.84 * x0 + 13.06 * x1 + 12.85 * x2 >= 50)
m.addConstr(2.88 * x0 + 7.18 * x2 >= 61)
m.addConstr(14.55 * x1 + 7.18 * x2 >= 27)
m.addConstr(2.88 * x0 + 14.55 * x1 + 7.18 * x2 >= 27)
m.addConstr(6.67 * x1 + 7.17 * x2 >= 15)
m.addConstr(8.91 * x0 + 6.67 * x1 + 7.17 * x2 >= 15)
m.addConstr(-x1 + 2 * x2 >= 0)
m.addConstr(3 * x0 - 2 * x2 >= 0)
m.addConstr(14.55 * x1 + 7.18 * x2 <= 73)
m.addConstr(2.88 * x0 + 14.55 * x1 <= 161)
m.addConstr(8.91 * x0 + 6.67 * x1 <= 34)
m.addConstr(8.91 * x0 + 6.67 * x1 + 7.17 * x2 <= 77)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Smoke detectors: ", x0.varValue)
    print("Packs of paper: ", x1.varValue)
    print("Black pens: ", x2.varValue)
else:
    print("The model is infeasible")
