
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    hank_hours = model.addVar(lb=0, name="hank_hours")  # Continuous
    mary_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="mary_hours") # Integer


    # Set objective function
    obj = 8.62 * hank_hours**2 + 7.29 * hank_hours * mary_hours + 1.66 * mary_hours**2 + 9.21 * hank_hours + 9.73 * mary_hours
    model.setObjective(obj, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(3 * hank_hours + 13 * mary_hours >= 13, "paperwork_min")
    model.addConstr(6 * hank_hours + 3 * mary_hours >= 22, "work_quality_min")
    model.addConstr(13 * hank_hours + 13 * mary_hours >= 16, "computer_competence_min")
    model.addConstr(-9 * hank_hours + 4 * mary_hours >= 0, "constraint4")
    model.addConstr(3 * hank_hours + 13 * mary_hours <= 19, "paperwork_max")
    model.addConstr(6 * hank_hours + 3 * mary_hours <= 63, "work_quality_max")
    model.addConstr(13 * hank_hours**2 + 13 * mary_hours**2 <= 34, "computer_competence_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimal objective value: {model.objVal}")
        print(f"Hours worked by Hank: {hank_hours.x}")
        print(f"Hours worked by Mary: {mary_hours.x}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
