
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Hank")
x2 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Mary")

# Set the objective function
m.setObjective(8.62*x1**2 + 7.29*x1*x2 + 1.66*x2**2 + 9.21*x1 + 9.73*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x1 + 13*x2 >= 13, name="paperwork_competence")
m.addConstr(6*x1 + 3*x2 >= 22, name="work_quality_rating")
m.addConstr(13*x1 + 13*x2 >= 16, name="computer_competence")
m.addConstr(-9*x1 + 4*x2 >= 0, name="linear_constraint")
m.addConstr(3*x1 + 13*x2 <= 19, name="upper_bound_paperwork")
m.addConstr(6*x1 + 3*x2 <= 63, name="upper_bound_work_quality")
m.addConstr((13*x1)**2 + (13*x2)**2 <= 34, name="upper_bound_computer_squared")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Hours worked by Hank:", x1.x)
    print("Hours worked by Mary:", x2.x)
else:
    print("No optimal solution found.")
