
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(lb=0, name="hours_worked_by_Hank")  # hours worked by Hank
x2 = m.addVar(lb=0, type=gurobi.GRB.INTEGER, name="hours_worked_by_Mary")  # hours worked by Mary

# Objective function
m.setObjective(8.62*x1**2 + 7.29*x1*x2 + 1.66*x2**2 + 9.21*x1 + 9.73*x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(3*x1 + 13*x2 >= 13, name="paperwork_competence_rating")
m.addConstr(6*x1 + 3*x2 >= 22, name="work_quality_rating")
m.addConstr(13*x1 + 13*x2 >= 16, name="computer_competence_rating")
m.addConstr(-9*x1 + 4*x2 >= 0, name="labor_hours_constraint")
m.addConstr(3*x1 + 13*x2 <= 19, name="paperwork_competence_rating_upper_bound")
m.addConstr(6*x1 + 3*x2 <= 63, name="work_quality_rating_upper_bound")
m.addConstr((13*x1)**2 + (13*x2)**2 <= 34, name="computer_competence_rating_squared_upper_bound")

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Hank: {x1.varValue}")
    print(f"Hours worked by Mary: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
