
import gurobipy as gp

# Create a new model
m = gp.Model("cybersecurity_optimization")

# Create variables
security_onions = m.addVar(vtype=gp.GRB.INTEGER, name="security_onions")
honeypots = m.addVar(vtype=gp.GRB.INTEGER, name="honeypots")
SOC_operators = m.addVar(vtype=gp.GRB.INTEGER, name="SOC_operators")
security_engineers = m.addVar(vtype=gp.GRB.INTEGER, name="security_engineers")
intrusion_analysts = m.addVar(vtype=gp.GRB.INTEGER, name="intrusion_analysts")
system_administrators = m.addVar(vtype=gp.GRB.INTEGER, name="system_administrators")


# Set objective function
m.setObjective(1*security_onions + 6*honeypots + 2*SOC_operators + 3*security_engineers + 9*intrusion_analysts + 2*system_administrators, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9*security_onions + 16*honeypots + 11*SOC_operators + 27*security_engineers + 14*intrusion_analysts + 12*system_administrators <= 825, "r0")
m.addConstr(14*security_onions + 9*honeypots + 1*SOC_operators + 13*security_engineers + 32*intrusion_analysts + 28*system_administrators <= 391, "r1")
m.addConstr(22*security_onions + 9*honeypots + 30*SOC_operators + 20*security_engineers + 12*intrusion_analysts + 16*system_administrators <= 230, "r2")


# ... (rest of the constraints from the JSON "constraints" section)

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

