
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls_of_pasta")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hot_dogs")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oranges")
    x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="corn_cobs")


    # Set objective function
    m.setObjective(8*x0 + 5*x1 + 9*x2 + 6*x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3*x2 + 2*x3 >= 91, "c0")
    m.addConstr(7*x0 + 1*x1 >= 34, "c1")
    m.addConstr(7*x0 + 2*x3 >= 90, "c2")
    m.addConstr(16*x1 + 7*x2 >= 70, "c3")
    m.addConstr(6*x0 + 7*x2 >= 40, "c4")
    m.addConstr(6*x0 + 16*x1 + 2*x3 >= 68, "c5")
    m.addConstr(1*x1 + 3*x2 <= 253, "c6")
    m.addConstr(3*x2 + 2*x3 <= 230, "c7")
    m.addConstr(1*x1 + 2*x3 <= 390, "c8")
    m.addConstr(7*x0 + 3*x2 <= 341, "c9")
    m.addConstr(7*x0 + 1*x1 + 3*x2 <= 122, "c10")
    m.addConstr(7*x0 + 1*x1 + 3*x2 + 2*x3 <= 122, "c11")
    m.addConstr(6*x0 + 7*x2 <= 437, "c12")
    m.addConstr(6*x0 + 2*x3 <= 185, "c13")
    m.addConstr(6*x0 + 16*x1 <= 229, "c14")
    m.addConstr(6*x0 + 16*x1 + 7*x2 + 2*x3 <= 229, "c15")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status:", m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
