
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = {}
item_names = ['cartons of milk', 'rubber gloves', 'toilet paper rolls', 'diapers', 'paper towel rolls', 'dish soap bottles', 'cookies']
for i in range(len(item_names)):
    x[i] = m.addVar(vtype=GRB.INTEGER, name=item_names[i])


# Set objective function
objective = 9*x[0]**2 + 5*x[0]*x[1] + 5*x[0]*x[2] + 7*x[0]*x[3] + 4*x[0]*x[4] + 7*x[0]*x[5] + 5*x[1]*x[2] + 1*x[1]*x[3] + 8*x[1]*x[5] + 1*x[2]**2 + 7*x[2]*x[3] + 9*x[2]*x[4] + 4*x[2]*x[5] + 9*x[2]*x[6] + 2*x[3]**2 + 3*x[3]*x[5] + 4*x[3]*x[6] + 7*x[4]**2 + 5*x[4]*x[5] + 3*x[5]**2 + 5*x[5]*x[6] + 4*x[6]**2 + 8*x[0] + 5*x[1] + 5*x[2] + 8*x[4] + 4*x[5] + 1*x[6]
m.setObjective(objective, GRB.MINIMIZE)

# Add constraints
weights = [12, 1, 14, 14, 10, 20, 19]
sustainability_scores = [3, 3, 8, 7, 18, 14, 19]
resource_constraints = {'weight': 327, 'sustainability score': 588}

for resource, bound in resource_constraints.items():
    if resource == 'weight':
        values = weights
    else:
        values = sustainability_scores
    m.addConstr(gp.quicksum(values[i] * x[i] for i in range(len(item_names))) <= bound, resource)


with open('constraints.txt', 'r') as f:
    constraints = f.readlines()

for constraint in constraints:
    m.addConstr(eval(constraint))


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

