
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x = m.addVars(6, lb=0, name=["x0", "x1", "x2", "x3", "x4", "x5"])


    # Set objective function
    m.setObjective(6.93 * x[0] + 3.69 * x[1] + 5.72 * x[2] + 7.43 * x[3] + 6.45 * x[4] + 4.87 * x[5], gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(0.95 * x[0] + 1.44 * x[1] + 3.75 * x[2] + 2.91 * x[3] + 3.63 * x[4] + 1.95 * x[5] <= 197)
    m.addConstr(1.46 * x[0] + 4.4 * x[1] + 4.06 * x[2] + 3.6 * x[3] + 2.51 * x[4] + 2.47 * x[5] <= 204)
    # ... (rest of the constraints from the JSON "constraints" section)
    m.addConstr(3.75 * x[2] + 2.91 * x[3] >= 25)
    m.addConstr(1.44 * x[1] + 2.91 * x[3] >= 15)
    m.addConstr(3.75 * x[2] + 1.95 * x[5] >= 27)
    # ... (add all remaining constraints)
    m.addConstr(8 * x[1] - 7 * x[4] >= 0)
    m.addConstr(2.91 * x[3] + 3.63 * x[4] <= 102)
    # ... (add all remaining constraints)


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
