
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.CONTINUOUS, name="x0") # milligrams of calcium
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="x1") # milligrams of vitamin B4
    x2 = m.addVar(vtype=GRB.CONTINUOUS, name="x2") # milligrams of vitamin B1


    # Set objective function
    m.setObjective(4.36*x0**2 + 4.01*x0*x1 + 9.16*x0 + 3.03*x1 + 6.23*x2, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(1.38*x0 + 1.33*x2 >= 17, "c0")
    m.addConstr(0.27*x0**2 + 1.31*x1**2 >= 13, "c1")
    m.addConstr(0.27*x0 + 1.31*x1 + 1.8*x2 >= 12, "c2")
    m.addConstr(1.38*x0**2 + 1.33*x2**2 <= 70, "c3")
    m.addConstr(1.11*x1 + 1.33*x2 <= 108, "c4")
    m.addConstr(1.38*x0**2 + 1.11*x1**2 <= 51, "c5")
    m.addConstr(1.38*x0 + 1.11*x1 + 1.33*x2 <= 51, "c6")
    m.addConstr(1.31*x1 + 1.8*x2 <= 35, "c7")
    m.addConstr(0.27*x0 + 1.8*x2 <= 42, "c8")
    m.addConstr(0.27*x0 + 1.31*x1 + 1.8*x2 <= 42, "c9")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
