
import gurobi

def optimize():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="milligrams of calcium", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x1 = model.addVar(name="milligrams of vitamin B4", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="milligrams of vitamin B1", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(4.36 * x0**2 + 4.01 * x0 * x1 + 9.16 * x0 + 3.03 * x1 + 6.23 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(1.38 * x0 <= 108)
    model.addConstr(0.27 * x0 <= 57)
    model.addConstr(1.11 * x1 <= 108)
    model.addConstr(1.31 * x1 <= 57)
    model.addConstr(1.33 * x2 <= 108)
    model.addConstr(1.8 * x2 <= 57)
    model.addConstr(1.38 * x0 + 1.33 * x2 >= 17)
    model.addConstr(0.27 * x0**2 + 1.31 * x1**2 >= 13)
    model.addConstr(0.27 * x0 + 1.31 * x1 + 1.8 * x2 >= 12)
    model.addConstr(1.9044 * x0**2 + 1.7689 * x2**2 <= 70)
    model.addConstr(1.11 * x1 + 1.33 * x2 <= 108)
    model.addConstr(1.9044 * x0**2 + 1.2321 * x1**2 <= 51)
    model.addConstr(1.38 * x0 + 1.11 * x1 + 1.33 * x2 <= 51)
    model.addConstr(1.31 * x1 + 1.8 * x2 <= 35)
    model.addConstr(0.27 * x0 + 1.8 * x2 <= 42)
    model.addConstr(0.27 * x0 + 1.31 * x1 + 1.8 * x2 <= 42)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Milligrams of calcium: ", x0.varValue)
        print("Milligrams of vitamin B4: ", x1.varValue)
        print("Milligrams of vitamin B1: ", x2.varValue)
    else:
        print("The model is infeasible")

optimize()
