
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    magnesium = m.addVar(vtype=gp.GRB.INTEGER, name="magnesium")
    vitamin_b4 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b4")
    vitamin_d = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_d")
    fat = m.addVar(vtype=gp.GRB.CONTINUOUS, name="fat")

    # Set objective function
    m.setObjective(8.32 * magnesium + 2.42 * vitamin_b4 + 1.56 * vitamin_d + 8.06 * fat, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(7 * magnesium + 11 * vitamin_b4 + 5 * vitamin_d + 9 * fat <= 154, "c0")
    m.addConstr(8 * magnesium + 8 * vitamin_b4 + 2 * vitamin_d + 6 * fat <= 102, "c1")
    m.addConstr(5 * vitamin_d + 9 * fat >= 26, "c2")
    m.addConstr(11 * vitamin_b4 + 5 * vitamin_d >= 30, "c3")
    m.addConstr(7 * magnesium + 11 * vitamin_b4 >= 34, "c4")
    m.addConstr(11 * vitamin_b4 + 9 * fat >= 18, "c5")
    m.addConstr(7 * magnesium + 5 * vitamin_d >= 16, "c6")
    m.addConstr(7 * magnesium + 9 * fat >= 21, "c7")
    m.addConstr(7 * magnesium + 11 * vitamin_b4 + 5 * vitamin_d + 9 * fat >= 21, "c8")
    m.addConstr(8 * magnesium + 2 * vitamin_d >= 19, "c9")
    m.addConstr(8 * vitamin_b4 + 6 * fat >= 21, "c10")
    m.addConstr(8 * magnesium + 2 * vitamin_d + 6 * fat >= 17, "c11")
    m.addConstr(8 * magnesium + 8 * vitamin_b4 + 2 * vitamin_d + 6 * fat >= 17, "c12")
    m.addConstr(7 * magnesium - 5 * vitamin_b4 >= 0, "c13")
    m.addConstr(-8 * magnesium + 5 * vitamin_d >= 0, "c14")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('magnesium:', magnesium.x)
        print('vitamin_b4:', vitamin_b4.x)
        print('vitamin_d:', vitamin_d.x)
        print('fat:', fat.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
