
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="orange_trees")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="basil_plants")
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="peonies")
x3 = m.addVar(vtype=gp.GRB.INTEGER, name="vincas")

# Set objective function
m.setObjective(9.23 * x0 + 5.85 * x1 + 9.02 * x2 + 8.78 * x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(11.72 * x2 + 8.97 * x3 >= 35)
m.addConstr(8.27 * x1 + 8.97 * x3 >= 39)
m.addConstr(12.3 * x0 + 8.97 * x3 >= 83)
m.addConstr(12.3 * x0 + 8.27 * x1 + 11.72 * x2 + 8.97 * x3 >= 83)
m.addConstr(13.88 * x0 + 3.73 * x1 >= 37)
m.addConstr(7.2 * x2 + 4.61 * x3 >= 16)
m.addConstr(13.88 * x0 + 4.61 * x3 >= 44)
m.addConstr(13.88 * x0 + 3.73 * x1 + 4.61 * x3 >= 33)
m.addConstr(13.88 * x0 + 3.73 * x1 + 7.2 * x2 + 4.61 * x3 >= 33)
m.addConstr(21.16 * x0 + 17.79 * x3 >= 91)
m.addConstr(0.82 * x2 + 17.79 * x3 >= 57)
m.addConstr(21.16 * x0 + 12.95 * x1 >= 91)
m.addConstr(21.16 * x0 + 0.82 * x2 >= 106)
m.addConstr(21.16 * x0 + 12.95 * x1 + 0.82 * x2 + 17.79 * x3 >= 106)
m.addConstr(-3 * x1 + 8 * x3 >= 0)
m.addConstr(-7 * x1 + 9 * x2 >= 0)
m.addConstr(8.27 * x1 + 11.72 * x2 <= 170)
m.addConstr(8.27 * x1 + 8.97 * x3 <= 112)
m.addConstr(12.3 * x0 + 8.27 * x1 + 11.72 * x2 <= 264)
m.addConstr(3.73 * x1 + 7.2 * x2 <= 65)
m.addConstr(21.16 * x0 + 0.82 * x2 + 17.79 * x3 <= 445)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

