
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # orange trees
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # basil plants
    x3 = model.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # peonies
    x4 = model.addVar(name="x4", vtype=gurobi.GRB.INTEGER)  # vincas

    # Objective function
    model.setObjective(9.23 * x1 + 5.85 * x2 + 9.02 * x3 + 8.78 * x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(12.3 * x1 + 11.72 * x3 + 8.97 * x4 >= 35)
    model.addConstr(8.27 * x2 + 8.97 * x4 >= 39)
    model.addConstr(12.3 * x1 + 8.97 * x4 >= 83)
    model.addConstr(12.3 * x1 + 8.27 * x2 + 11.72 * x3 + 8.97 * x4 >= 83)
    model.addConstr(13.88 * x1 + 3.73 * x2 >= 37)
    model.addConstr(7.2 * x3 + 4.61 * x4 >= 16)
    model.addConstr(13.88 * x1 + 4.61 * x4 >= 44)
    model.addConstr(13.88 * x1 + 3.73 * x2 + 4.61 * x4 >= 33)
    model.addConstr(13.88 * x1 + 3.73 * x2 + 7.2 * x3 + 4.61 * x4 >= 33)
    model.addConstr(21.16 * x1 + 17.79 * x4 >= 91)
    model.addConstr(0.82 * x3 + 17.79 * x4 >= 57)
    model.addConstr(21.16 * x1 + 12.95 * x2 >= 91)
    model.addConstr(21.16 * x1 + 0.82 * x3 >= 106)
    model.addConstr(21.16 * x1 + 12.95 * x2 + 0.82 * x3 + 17.79 * x4 >= 106)
    model.addConstr(-3 * x2 + 8 * x4 >= 0)
    model.addConstr(-7 * x2 + 9 * x3 >= 0)
    model.addConstr(8.27 * x2 + 11.72 * x3 <= 170)
    model.addConstr(8.27 * x2 + 8.97 * x4 <= 112)
    model.addConstr(12.3 * x1 + 8.27 * x2 + 11.72 * x3 <= 264)
    model.addConstr(3.73 * x2 + 7.2 * x3 <= 65)
    model.addConstr(21.16 * x1 + 0.82 * x3 + 17.79 * x4 <= 445)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x1 (orange trees): ", x1.varValue)
        print("x2 (basil plants): ", x2.varValue)
        print("x3 (peonies): ", x3.varValue)
        print("x4 (vincas): ", x4.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
