
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="dish_soap_bottles")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="rubber_gloves")


    # Set objective function
    m.setObjective(5*x0 + 7*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(5.18*x0 + 7.26*x1 >= 5, "value_min")
    m.addConstr(5.67*x0 + 6.51*x1 >= 11, "space_min")
    m.addConstr(4*x0 - 7*x1 >= 0, "ratio")
    m.addConstr(5.18*x0 + 7.26*x1 <= 21, "value_max")
    m.addConstr(5.67*x0 + 6.51*x1 <= 27, "space_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('dish_soap_bottles: %g' % x0.x)
        print('rubber_gloves: %g' % x1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

