
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x0 = m.addVar(vtype=GRB.INTEGER, name="dish_soap_bottles")
x1 = m.addVar(vtype=GRB.INTEGER, name="rubber_gloves")

# Set the objective function
m.setObjective(5*x0 + 7*x1, GRB.MAXIMIZE)

# Add constraints to the model
m.addConstr(5.18*x0 + 7.26*x1 >= 5, "total_value_at_least_5")
m.addConstr(5.18*x0 + 7.26*x1 <= 21, "total_value_no_more_than_21")
m.addConstr(5.67*x0 + 6.51*x1 >= 11, "storage_space_at_least_11")
m.addConstr(5.67*x0 + 6.51*x1 <= 27, "storage_space_no_more_than_27")
m.addConstr(4*x0 - 7*x1 >= 0, "dish_soap_bottles_vs_rubber_gloves")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Dish soap bottles: {x0.x}")
    print(f"Rubber gloves: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
