
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="dish_soap_bottles", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="rubber_gloves", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(5 * x1 + 7 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5.18 * x1 + 7.26 * x2 >= 5, name="total_value_min")
    model.addConstr(5.67 * x1 + 6.51 * x2 >= 11, name="storage_space_min")
    model.addConstr(4 * x1 - 7 * x2 >= 0, name="dish_soap_vs_rubber_gloves")
    model.addConstr(5.18 * x1 + 7.26 * x2 <= 22, name="total_value_max")
    model.addConstr(5.67 * x1 + 6.51 * x2 <= 33, name="storage_space_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"dish soap bottles: {x1.varValue}")
        print(f"rubber gloves: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
