
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
lemons = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="lemons")
corn_cobs = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="corn_cobs")
apples = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="apples")
ham_sandwiches = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="ham_sandwiches")

# Set objective function
m.setObjective(2*lemons + 5*corn_cobs + 7*apples + 2*ham_sandwiches, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*lemons + 10*corn_cobs + 25*apples + 8*ham_sandwiches <= 475, "fiber_constraint")
m.addConstr(24*lemons + 16*corn_cobs + 17*apples + 5*ham_sandwiches <= 288, "umami_constraint")
m.addConstr(24*lemons + 17*apples + 5*ham_sandwiches >= 70, "umami_constraint1")
m.addConstr(24*lemons + 16*corn_cobs + 17*apples >= 70, "umami_constraint2")
m.addConstr(24*lemons + 16*corn_cobs + 5*ham_sandwiches >= 70, "umami_constraint3")
m.addConstr(24*lemons + 17*apples + 5*ham_sandwiches >= 69, "umami_constraint4")
m.addConstr(24*lemons + 16*corn_cobs + 17*apples >= 69, "umami_constraint5")
m.addConstr(24*lemons + 16*corn_cobs + 5*ham_sandwiches >= 69, "umami_constraint6")
m.addConstr(24*lemons + 17*apples + 5*ham_sandwiches >= 72, "umami_constraint7")
m.addConstr(24*lemons + 16*corn_cobs + 17*apples >= 72, "umami_constraint8")
m.addConstr(24*lemons + 16*corn_cobs + 5*ham_sandwiches >= 72, "umami_constraint9")
m.addConstr(10*lemons + 10*corn_cobs <= 382, "fiber_constraint1")
m.addConstr(10*corn_cobs + 25*apples <= 240, "fiber_constraint2")
m.addConstr(25*apples + 8*ham_sandwiches <= 447, "fiber_constraint3")
m.addConstr(10*lemons + 8*ham_sandwiches <= 130, "fiber_constraint4")
m.addConstr(10*lemons + 25*apples <= 346, "fiber_constraint5")
m.addConstr(10*lemons + 10*corn_cobs + 25*apples + 8*ham_sandwiches <= 346, "fiber_constraint6")
m.addConstr(24*lemons + 16*corn_cobs <= 270, "umami_constraint10")
m.addConstr(24*lemons + 17*apples <= 197, "umami_constraint11")
m.addConstr(16*corn_cobs + 5*ham_sandwiches <= 74, "umami_constraint12")
m.addConstr(16*corn_cobs + 17*apples <= 162, "umami_constraint13")
m.addConstr(16*corn_cobs + 17*apples + 5*ham_sandwiches <= 219, "umami_constraint14")
m.addConstr(24*lemons + 16*corn_cobs + 17*apples + 5*ham_sandwiches <= 219, "umami_constraint15")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

