
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="lemons", lb=0, ub=gp.GRB.INFINITY)
x1 = m.addVar(name="corn_cobs", lb=0, vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="apples", lb=0, vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="ham_sandwiches", lb=0)

# Define the objective function
m.setObjective(2*x0 + 5*x1 + 7*x2 + 2*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x0 + 10*x1 + 25*x2 + 8*x3 <= 475, name="total_fiber")
m.addConstr(10*x1 + 25*x2 <= 240, name="fiber_corn_apples")
m.addConstr(25*x2 + 8*x3 <= 447, name="fiber_apples_sandwiches")
m.addConstr(10*x0 + 8*x3 <= 130, name="fiber_lemons_sandwiches")
m.addConstr(10*x0 + 25*x2 <= 346, name="fiber_lemons_apples")
m.addConstr(10*x0 + 10*x1 + 25*x2 + 8*x3 <= 346, name="total_fiber_limit")

m.addConstr(24*x0 + 17*x2 + 5*x3 >= 70, name="umami_lemons_apples_sandwiches")
m.addConstr(24*x0 + 16*x1 + 17*x2 >= 70, name="umami_lemons_corn_apples")
m.addConstr(24*x0 + 16*x1 + 5*x3 >= 70, name="umami_lemons_corn_sandwiches")
m.addConstr(24*x0 + 17*x2 + 5*x3 >= 69, name="umami_lemons_apples_sandwiches_69")
m.addConstr(24*x0 + 16*x1 + 17*x2 >= 69, name="umami_lemons_corn_apples_69")
m.addConstr(24*x0 + 16*x1 + 5*x3 >= 69, name="umami_lemons_corn_sandwiches_69")
m.addConstr(24*x0 + 17*x2 + 5*x3 >= 72, name="umami_lemons_apples_sandwiches_72")
m.addConstr(24*x0 + 16*x1 + 17*x2 >= 72, name="umami_lemons_corn_apples_72")
m.addConstr(24*x0 + 16*x1 + 5*x3 >= 72, name="umami_lemons_corn_sandwiches_72")

m.addConstr(24*x0 + 16*x1 <= 270, name="umami_lemons_corn")
m.addConstr(24*x0 + 17*x2 <= 197, name="umami_lemons_apples")
m.addConstr(16*x1 + 5*x3 <= 74, name="umami_corn_sandwiches")
m.addConstr(16*x1 + 17*x2 <= 162, name="umami_corn_apples")
m.addConstr(16*x1 + 17*x2 + 5*x3 <= 219, name="umami_corn_apples_sandwiches")
m.addConstr(24*x0 + 16*x1 + 17*x2 + 5*x3 <= 219, name="umami_total")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Lemons: ", x0.varValue)
    print("Corn Cobs: ", x1.varValue)
    print("Apples: ", x2.varValue)
    print("Ham Sandwiches: ", x3.varValue)
else:
    print("The model is infeasible")
