
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    medical_platoons = m.addVar(vtype=GRB.INTEGER, name="medical_platoons")
    signal_platoons = m.addVar(vtype=GRB.INTEGER, name="signal_platoons")


    # Set objective function
    m.setObjective(6 * medical_platoons + 7 * signal_platoons, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(1 * medical_platoons + 2 * signal_platoons >= 12, "min_deployment_weight")
    m.addConstr(7 * medical_platoons - 10 * signal_platoons >= 0, "medical_signal_ratio")
    m.addConstr(1 * medical_platoons + 2 * signal_platoons <= 25, "max_deployment_weight")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print(f"Optimal solution found:")
        print(f"  Medical Platoons: {medical_platoons.x}")
        print(f"  Signal Platoons: {signal_platoons.x}")
        print(f"  Objective Value: {m.objVal}")
    elif m.status == GRB.INFEASIBLE:
        print("Model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
