
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(vtype=GRB.INTEGER, name="medical_platoons")
x2 = m.addVar(vtype=GRB.INTEGER, name="signal_platoons")

# Set objective function
m.setObjective(6*x1 + 7*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + 2*x2 >= 12, "minimum_deployment_weight")
m.addConstr(7*x1 - 10*x2 >= 0, "platoon_ratio")
m.addConstr(x1 + 2*x2 <= 25, "maximum_deployment_weight")

# Optimize model
m.optimize()

# Print results
for v in m.getVars():
    print("%s %f" % (v.varName, v.x))

print("Obj: %f" % m.objVal)
