
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="medical_platoons", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="signal_platoons", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(6 * x1 + 7 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 + 2 * x2 >= 12, name="deployment_weight_min")
    model.addConstr(7 * x1 - 10 * x2 >= 0, name="medical_signal_relationship")
    model.addConstr(x1 + 2 * x2 <= 25, name="combined_deployment_weight_max")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Medical platoons: {x1.varValue}")
        print(f"Signal platoons: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
